var samplePageObj = {
  // 샘플 타이틀
  title: '소계 기능',
  subtitle: '특정 컬럼을 기준으로, 지정한 컬럼들에 대한 소계 값을 보여주는 기능입니다.',
  // 샘플 설명
  desc: 'makeSubTotal 메소드를 통해 소계행을 생성하여 화면에 보여줄수 있으며, removeSubTotal 메소드를 통해 생성된 소계행을 제거할 수 있습니다. 대용량 모드(FastLoad)에선 사용 불가능합니다.',

  // 객체 초기화 구문
  init: {
    Def: {
      Col: {
        Spanned: 1,
      },
      Row: {
        CanFormula: 1,
        Spanned: 1
      }
    },
    Cfg: {
      SearchMode: 0,
      SuppressMessage: 3,
      DataMerge: 3,
      SelectionSummary: {
        Mode: 'DelRow',
        Width: 400
      },
      InfoRowConfig: {
        Visible: 1,
        Layout: [
          'SummaryLabel',
          'Count'
        ],
        Space: 'Top'
      }// 건수 정보 표시
    },
    LeftCols: [],
    Cols: [
      {
        Header: '정책 사업',
        Name: 'sPolicy',
        Type: 'Text',
        MinWidth: 150,
        RelWidth: 1
      },
      {
        Header: '단위 사업',
        Name: 'sUnit',
        Type: 'Text',
        MinWidth: 150,
        RelWidth: 1
      },
      {
        Header: '세부사업',
        Name: 'sDetail',
        Type: 'Text',
        MinWidth: 150,
        RelWidth: 1
      },
      {
        Header: 'A',
        Name: 'A',
        Type: 'Int'
      },
      {
        Header: 'B',
        Name: 'B',
        Type: 'Int'
      },
      {
        Header: 'C',
        Name: 'C',
        Type: 'Int'
      },
      {
        Header: 'D',
        Name: 'D',
        Type: 'Int'
      },
      {
        Header: 'E',
        Name: 'E',
        Type: 'Int'
      },
      {
        Header: 'F',
        Name: 'F',
        Type: 'Int',
        Formula: 'E + 10'
      }
    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<button onclick=\'sampleBtn(this)\' class=\'mgr10\'>단일 컬럼 소계</button> <button onclick=\'sampleBtn(this)\' class=\'mgr10\'>단일 컬럼 소계/누계</button><hr/> <button onclick=\'sampleBtn(this)\' class=\'mgr10\'>다중 컬럼 소계</button> <button onclick=\'sampleBtn(this)\' class=\'mgr10\'>다중 컬럼 소계/누계</button><hr/> <button onclick=\'sampleBtn(this)\' class=\'mgr10\'>소계행 삭제</button>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },
  // 버튼 클릭시 기능 로직
  action: function () {
    switch (arguments[0].innerText) {
      case '단일 컬럼 소계':
        sheet.makeSubTotal([
          {
            stdCol: 'sPolicy',
            sumCols: 'A|B|C|D',
            position: 'bottom',
            captionCol: [
              {
                col: 'sPolicy',
                val: '%s: %col',
                cumVal: '%s: %col',
                span: 3
              },
              {
                col: 'E',
                val: ' ',
                cumVal: ' ',
                span: 2
              }
            ],
          }
        ]);
        break;
      case '단일 컬럼 소계/누계':
        sheet.makeSubTotal([
          {
            stdCol: 'sPolicy',
            sumCols: 'A|B|C|D',
            captionCol: [
              {
                col: 'sPolicy',
                val: '%s: %col',
                cumVal: '%s: %col',
                span: 3
              }
            ],
            showCumulate: 1,
            position: 'bottom'
          }
        ]);
        break;
      case '다중 컬럼 소계':
        sheet.makeSubTotal([
          {
            stdCol: 'sPolicy',
            sumCols: 'B|C',
            position: 'bottom',
            color: '#6F8CB3'
          },
          {
            stdCol: 'sUnit',
            avgCols: 'B|C',
            captionCol: [
              {
                col: 'sUnit',
                val: '%s: %col'
              }
            ],
            position: 'bottom',
            color: '#C1CEDE'
          },
        ]);
        break;
      case '다중 컬럼 소계/누계':
        sheet.makeSubTotal([
          {
            stdCol: 'sPolicy',
            sumCols: 'B|C',
            captionCol: [
              {
                col: 'sPolicy',
                val: '%s: %col',
                cumVal: '%s: %col'
              }
            ],
            showCumulate: 1,
            position: 'bottom',
            color: '#6F8CB3'
          },
          {
            stdCol: 'sUnit',
            avgCols: 'B|C',
            captionCol: [
              {
                col: 'sUnit',
                val: '%s: %col',
                cumVal: '%s: %col'
              }
            ],
            showCumulate: 1,
            position: 'bottom',
            color: '#C1CEDE'
          },
          {
            stdCol: 'sDetail',
            avgCols: 'A|D',
            captionCol: [
              {
                col: 'sDetail',
                val: '%s: %col',
                cumVal: '%s: %col'
              }
            ],
            countCols: 'E',
            showCumulate: 1,
            position: 'bottom',
          }
        ]);
        break;
      case '소계행 삭제':
        sheet.removeSubTotal();
        break;
      // no default
    }
  },

  // event구문
  event: {
  },

  // data
  data: [
    {
      sPolicy: '정적자원운용',
      sUnit: '정규직인건비',
      sDetail: '교원인건비',
      A: '3530855848000',
      B: '1904204573440',
      C: '19847770130',
      D: '1924052343569.9998',
      E: '54.49252'
    },
    {
      sPolicy: '인적자원운용',
      sUnit: '정규직인건비',
      sDetail: '지방공무원인건비',
      A: '461430193000',
      B: '247492523010',
      C: '2628843840',
      D: '250121366850',
      E: '54.205678'
    },
    {
      sPolicy: '인적자원운용',
      sUnit: '비정규직인건비',
      sDetail: '계약제교원인건비',
      A: '194234361000',
      B: '110681334570',
      C: '1160516120',
      D: '111841850690',
      E: '57.580878'
    },
    {
      sPolicy: '인적자원운용',
      sUnit: '비정규직인건비',
      sDetail: '계약제직원인건비',
      A: '7018400000',
      B: '3443668820',
      C: '2340000',
      D: '3446008820',
      E: '49.099636'
    },
    {
      sPolicy: '인적자원운용',
      sUnit: '교원역량강화',
      sDetail: '교원연수지원',
      A: '2971246000',
      B: '2346726550',
      C: '0',
      D: '2346726550',
      E: '78.981227'
    },
    {
      sPolicy: '인적자원운용',
      sUnit: '교원역량강화',
      sDetail: '교원연수운영',
      A: '2739113250',
      B: '1502240580',
      C: '0',
      D: '1502240580',
      E: '54.844048'
    },
    {
      sPolicy: '인적자원운용',
      sUnit: '지방공무원역량강화',
      sDetail: '지방공무원연수지원',
      A: '442570000',
      B: '283276930',
      C: '0',
      D: '283276930',
      E: '64.00726'
    },
    {
      sPolicy: '인적자원운용',
      sUnit: '지방공무원역량강화',
      sDetail: '지방공무원연수운영',
      A: '1169109000',
      B: '485450400',
      C: '0',
      D: '485450400',
      E: '41.523109'
    },
    {
      sPolicy: '인적자원운용',
      sUnit: '교원인사관리',
      sDetail: '교원임용관리',
      A: '3215238000',
      B: '1153427870',
      C: '0',
      D: '1153427870',
      E: '35.873794'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '교육과정개발운영',
      sDetail: '교육과정운영',
      A: '11281630000',
      B: '10060625060',
      C: '6620000',
      D: '10067245060',
      E: '89.235732'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '교육과정개발운영',
      sDetail: '교과자료개발보급',
      A: '144355000',
      B: '30621200',
      C: '0',
      D: '30621200',
      E: '21.212428'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '교육과정개발운영',
      sDetail: '창의인성교육운영',
      A: '280820000',
      B: '159620000',
      C: '0',
      D: '159620000',
      E: '56.840681'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '교육과정개발운영',
      sDetail: '특색교육과정운영',
      A: '61843186000',
      B: '47466168040',
      C: '0',
      D: '47466168040',
      E: '76.752462'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '학력신장',
      sDetail: '학력향상지원',
      A: '2151934790',
      B: '1974256790',
      C: '0',
      D: '1974256790',
      E: '91.743337'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '수업지원장학활동',
      sDetail: '현장중심장학활동지원',
      A: '12478023000',
      B: '9582538400',
      C: '0',
      D: '9582538400',
      E: '76.795326'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '수업지원장학활동',
      sDetail: '수석교사제운영',
      A: '1454771000',
      B: '1201380000',
      C: '0',
      D: '1201380000',
      E: '82.58207'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '연구시범학교운영',
      sDetail: '연구시범학교운영',
      A: '1669450000',
      B: '1668610000',
      C: '0',
      D: '1668610000',
      E: '99.949684'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '교과교육연구회운영활성화',
      sDetail: '교과교육연구회지원',
      A: '256589000',
      B: '157835280',
      C: '880000',
      D: '158715280',
      E: '61.855839'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '유아교육진흥',
      sDetail: '유아교육지원',
      A: '2193337700',
      B: '1094969250',
      C: '0',
      D: '1094969250',
      E: '49.922511'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '유아교육진흥',
      sDetail: '유치원방과후과정운영',
      A: '3635250000',
      B: '3041490000',
      C: '30000000',
      D: '3071490000',
      E: '84.491851'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '진로진학교육',
      sDetail: '진로진학교육',
      A: '4256580000',
      B: '2655569820',
      C: '150000000',
      D: '2805569820',
      E: '65.911361'
    },
    {
      sPolicy: '교수-학습활동지원',
      sUnit: '학력평가',
      sDetail: '학력평가관리',
      A: '10215307000',
      B: '6955042810',
      C: '0',
      D: '6955042810',
      E: '68.084521'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '학비지원',
      sDetail: '저소득층자녀학비지원',
      A: '36624646500',
      B: '24655662500',
      C: '0',
      D: '24655662500',
      E: '67.319865'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '학비지원',
      sDetail: '특성화고장학금지원',
      A: '48897776000',
      B: '25290259340',
      C: '0',
      D: '25290259340',
      E: '51.720674'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '학비지원',
      sDetail: '기타교육비지원',
      A: '1285680000',
      B: '375361880',
      C: '0',
      D: '375361880',
      E: '29.195591'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '학비지원',
      sDetail: '교육급여지원',
      A: '62723206000',
      B: '23145348100',
      C: '0',
      D: '23145348100',
      E: '36.900773'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '방과후등교육지원',
      sDetail: '방과후학교운영',
      A: '51017336000',
      B: '37993758710',
      C: '0',
      D: '37993758710',
      E: '74.472251'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '방과후등교육지원',
      sDetail: '저소득층자녀방과후자유수강권지원',
      A: '25984800000',
      B: '15993135800',
      C: '0',
      D: '15993135800',
      E: '61.548043'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '급식지원',
      sDetail: '학기중급식비지원',
      A: '35611522000',
      B: '20722200000',
      C: '0',
      D: '20722200000',
      E: '58.189594'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '급식지원',
      sDetail: '토·공휴일중식지원',
      A: '5651532000',
      B: '3689453000',
      C: '0',
      D: '3689453000',
      E: '65.282352'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '정보화지원',
      sDetail: '정보화지원',
      A: '5646158000',
      B: '2089439330',
      C: '0',
      D: '2089439330',
      E: '37.006391'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '교육복지우선지원',
      sDetail: '교육복지우선지원',
      A: '43951618000',
      B: '32766707740',
      C: '2889480',
      D: '32769597220',
      E: '74.558341'
    },
    {
      sPolicy: '교육복지지원',
      sUnit: '누리과정지원',
      sDetail: '누리과정지원',
      A: '384128770000',
      B: '305151702500',
      C: '0',
      D: '305151702500',
      E: '79.43995'
    }
  ]
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
